<?php
/* =============== SIMPLE 3x-ui BULK ADD (LOGIN+SESSION) =============== */
/* فرم پایین صفحه رو پر کن، این اسکریپت:
   1) به /login لاگین می‌کنه و کوکی session می‌گیره
   2) برای هر Inbound ID، کلاینت رو به /{panel_path}/api/inbounds/addClient اضافه می‌کنه
*/

function h($s){ return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }

function http($url, $opts = []) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HEADER         => false,
        CURLOPT_SSL_VERIFYPEER => true,   // اگر SSL سلف‌ساین داری و خطا گرفتی موقتاً false کن
        CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_TIMEOUT        => 30,
    ] + $opts);
    $resp = curl_exec($ch);
    $info = curl_getinfo($ch);
    $err  = curl_error($ch);
    curl_close($ch);
    return [$resp, $info, $err];
}

function new_uuid() {
    $data = openssl_random_pseudo_bytes(16);
    $data[6] = chr((ord($data[6]) & 0x0f) | 0x40);
    $data[8] = chr((ord($data[8]) & 0x3f) | 0x80);
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}

$results = [];
$defaultBase   = "https://amirbeckham-you.iddns.ir:1267/";  // مثلا https://amirbeckham-you.iddns.ir:1267
$defaultPath   = "/jfObpLrDyGa0jpu";                    // یا /xui بسته به تم
$defaultIds    = "1-5";

if ($_SERVER['REQUEST_METHOD']==='POST') {
    $base   = rtrim(trim($_POST['base_url'] ?? $defaultBase), '/');
    $ppath  = '/' . trim($_POST['panel_path'] ?? 'panel', '/');   // panel یا xui
    $user   = trim($_POST['username'] ?? '');
    $pass   = trim($_POST['password'] ?? '');
    $idsRaw = trim($_POST['inbound_ids'] ?? $defaultIds);
    $email  = trim($_POST['email'] ?? 'newuser');
    $proto  = $_POST['proto'] ?? 'vless';      // vless یا trojan
    $flow   = trim($_POST['flow'] ?? '');
    $same   = isset($_POST['same_uuid']);
    $uuidCustom = trim($_POST['uuid'] ?? '');
    $totalGB = (int)($_POST['total_gb'] ?? 0);
    $expiryDays = (int)($_POST['expiry_days'] ?? 0);

    $expiryMs = 0;
    if ($expiryDays > 0) $expiryMs = (time() + $expiryDays*86400)*1000;

    // parse IDs
    $inboundIds = [];
    foreach (preg_split('/[,\s]+/', $idsRaw) as $p) {
        if ($p==='') continue;
        if (strpos($p,'-')!==false) { [$a,$b]=array_map('intval',explode('-',$p,2)); for($i=$a;$i<=$b;$i++) $inboundIds[]=$i; }
        else { $n=(int)$p; if($n) $inboundIds[]=$n; }
    }
    $inboundIds = array_values(array_unique($inboundIds));

    if (!$base || !$user || !$pass || empty($inboundIds)) {
        $results[] = ["id"=>"—","ok"=>false,"msg"=>"Base URL / Username / Password / Inbound IDs را کامل وارد کنید."];
    } else {
        // cookie jar
        $cookie = tempnam(sys_get_temp_dir(), 'xui_');

        // 1) LOGIN
        $loginUrl = $base . "/login";
        $postFields = http_build_query([
            "username" => $user,
            "password" => $pass,
        ]);
        [$resp,$info,$err] = http($loginUrl, [
            CURLOPT_POST       => true,
            CURLOPT_POSTFIELDS => $postFields,
            CURLOPT_HTTPHEADER => ["Content-Type: application/x-www-form-urlencoded"],
            CURLOPT_COOKIEJAR  => $cookie,
            CURLOPT_COOKIEFILE => $cookie,
        ]);

        if ($err) {
            $results[] = ["id"=>"—","ok"=>false,"msg"=>"خطای اتصال لاگین: $err"];
        } else {
            // تست یک call ساده برای اطمینان از سشن
            $apiBase = $base . $ppath . "/api";
            $testUrl = $apiBase . "/inbounds/list";
            [$_t,$_ti,$_te] = http($testUrl, [
                CURLOPT_HTTPHEADER => ["Accept: application/json"],
                CURLOPT_COOKIEJAR  => $cookie,
                CURLOPT_COOKIEFILE => $cookie,
            ]);
            if ($_te || ($_ti['http_code']>=400)) {
                $results[] = ["id"=>"—","ok"=>false,"msg"=>"لاگین/سشن معتبر نیست یا مسیر پنل اشتباه است. ($testUrl)"];
            } else {
                // 2) ADD CLIENTS
                $globalUuid = $uuidCustom ?: new_uuid();
                foreach ($inboundIds as $id) {
                    $uuid = $same ? $globalUuid : ($uuidCustom ?: new_uuid());

                    if ($proto==='trojan') {
                        $client = [
                            "enable"=>true,
                            "email"=>$email,
                            "password"=>$uuid,   // trojan
                            "limitIp"=>0,
                            "totalGB"=>$totalGB,
                            "expiryTime"=>$expiryMs,
                        ];
                    } else {
                        $client = [
                            "enable"=>true,
                            "email"=>$email,
                            "id"=>$uuid,         // vless/vmess
                            "flow"=>$flow,       // در صورت نیاز (Reality Vision)
                            "limitIp"=>0,
                            "totalGB"=>$totalGB,
                            "expiryTime"=>$expiryMs,
                        ];
                    }

                    $payload = json_encode(["id"=>(int)$id, "client"=>$client], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
                    $addUrl = $apiBase . "/inbounds/addClient";
                    [$r,$i,$e] = http($addUrl, [
                        CURLOPT_POST       => true,
                        CURLOPT_POSTFIELDS => $payload,
                        CURLOPT_HTTPHEADER => ["Content-Type: application/json"],
                        CURLOPT_COOKIEJAR  => $cookie,
                        CURLOPT_COOKIEFILE => $cookie,
                    ]);

                    $ok=false; $msg=""; $data=json_decode($r,true);
                    if ($e) { $msg="خطای اتصال: $e"; }
                    else if (isset($data['success']) && $data['success']) { $ok=true; $msg="اضافه شد."; }
                    else { $msg = "HTTP {$i['http_code']} - ".($data['msg'] ?? substr($r,0,200)); }

                    $results[] = ["id"=>$id,"ok"=>$ok,"msg"=>$msg,"uuid"=>$uuid];
                }
            }
        }
        @unlink($cookie);
    }
}
?>
<!doctype html>
<html lang="fa" dir="rtl">
<head>
<meta charset="utf-8">
<title>3x-ui Bulk Add (Login Session)</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
body{font-family:Tahoma,Arial,sans-serif;background:#fafafa;color:#222;padding:24px}
.card{background:#fff;border:1px solid #eee;border-radius:12px;padding:16px;max-width:920px;margin:0 auto;box-shadow:0 4px 12px rgba(0,0,0,.05)}
h1{margin:0 0 12px 0}
label{display:block;margin-top:10px;font-weight:600}
input,select{width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;margin-top:6px}
.row{display:grid;grid-template-columns:1fr 1fr;gap:12px}
.row-3{display:grid;grid-template-columns:1fr 1fr 1fr;gap:12px}
.btn{padding:10px 16px;border:0;border-radius:10px;background:#6a5acd;color:#fff;cursor:pointer;margin-top:14px}
.btn:hover{opacity:.9}
.help{font-size:12px;color:#666}
table{width:100%;border-collapse:collapse;margin-top:16px}
th,td{border:1px solid #eee;padding:8px;text-align:center}
.ok{color:#0a7a2f;font-weight:bold}
.err{color:#b00020;font-weight:bold}
code{background:#f4f4f4;border:1px solid #e5e5e5;border-radius:6px;padding:2px 6px}
</style>
</head>
<body>
<div class="card">
    <h1>افزودن سریع کلاینت به چند Inbound (با لاگین سشن)</h1>

    <form method="post">
        <div class="row">
            <div>
                <label>Base URL پنل
                    <input name="base_url" value="<?php echo h($_POST['base_url'] ?? $defaultBase); ?>" placeholder="مثلاً https://amirbeckham-you.iddns.ir:1267">
                </label>
            </div>
            <div>
                <label>Panel Path
                    <input name="panel_path" value="<?php echo h($_POST['panel_path'] ?? trim($defaultPath,'/')); ?>" placeholder="panel یا xui">
                    <div class="help">معمولاً panel یا xui (بدون / ابتدایی)</div>
                </label>
            </div>
        </div>

        <div class="row">
            <div>
                <label>نام کاربری پنل
                    <input name="username" value="<?php echo h($_POST['username'] ?? 'admin'); ?>">
                </label>
            </div>
            <div>
                <label>رمز عبور پنل
                    <input name="password" type="password" value="<?php echo h($_POST['password'] ?? ''); ?>">
                </label>
            </div>
        </div>

        <div class="row">
            <div>
                <label>ID اینباندها (کاما/بازه)
                    <input name="inbound_ids" value="<?php echo h($_POST['inbound_ids'] ?? $defaultIds); ?>">
                    <div class="help">مثلا: <code>1,2,3,4,5</code> یا <code>1-5</code></div>
                </label>
            </div>
            <div>
                <label>پروتکل کلاینت
                    <select name="proto">
                        <option value="vless" <?php echo (($_POST['proto'] ?? 'vless')==='vless'?'selected':''); ?>>VLESS/VMess (UUID)</option>
                        <option value="trojan" <?php echo (($_POST['proto'] ?? '')==='trojan'?'selected':''); ?>>Trojan (Password)</option>
                    </select>
                </label>
            </div>
        </div>

        <div class="row-3">
            <div>
                <label>ایمیل/Label کاربر
                    <input name="email" value="<?php echo h($_POST['email'] ?? 'newuser'); ?>">
                </label>
            </div>
            <div>
                <label>UUID دلخواه (اختیاری)
                    <input name="uuid" value="<?php echo h($_POST['uuid'] ?? ''); ?>">
                    <div class="help">خالی = خودکار</div>
                </label>
            </div>
            <div>
                <label>Flow (اختیاری برای Reality/Vision)
                    <input name="flow" value="<?php echo h($_POST['flow'] ?? ''); ?>" placeholder="مثلا xtls-rprx-vision">
                </label>
            </div>
        </div>

        <div class="row-3">
            <div>
                <label>حجم (GB)
                    <input name="total_gb" type="number" min="0" value="<?php echo h($_POST['total_gb'] ?? '0'); ?>">
                    <div class="help">0 = نامحدود</div>
                </label>
            </div>
            <div>
                <label>انقضا (روز)
                    <input name="expiry_days" type="number" min="0" value="<?php echo h($_POST['expiry_days'] ?? '0'); ?>">
                    <div class="help">0 = نامحدود</div>
                </label>
            </div>
            <div>
                <label>
                    <input type="checkbox" name="same_uuid" <?php echo isset($_POST['same_uuid']) ? 'checked' : 'checked'; ?>>
                    یک UUID برای همه اینباندها
                </label>
            </div>
        </div>

        <button class="btn" type="submit">ساخت کلاینت در اینباندها</button>
        <div class="help" style="margin-top:8px">
            اگر SSL سلف‌ساین داری و خطای SSL گرفتی، می‌تونی موقتاً در تابع <code>http()</code> گزینه‌های <code>CURLOPT_SSL_VERIFYPEER</code> و <code>CURLOPT_SSL_VERIFYHOST</code> را تغییر بدی.
        </div>
    </form>

    <?php if(!empty($results)): ?>
        <h2>نتیجه</h2>
        <table>
            <tr><th>Inbound ID</th><th>UUID/Password</th><th>وضعیت</th><th>پیام</th></tr>
            <?php foreach($results as $r): ?>
            <tr>
                <td><?php echo h($r['id']); ?></td>
                <td><code><?php echo h($r['uuid'] ?? '-'); ?></code></td>
                <td class="<?php echo $r['ok']?'ok':'err'; ?>"><?php echo $r['ok']?'موفق':'ناموفق'; ?></td>
                <td><?php echo h($r['msg']); ?></td>
            </tr>
            <?php endforeach; ?>
        </table>
    <?php endif; ?>
</div>
</body>
</html>
