<?php
header('Content-Type: application/json');

$basePath = __DIR__ . '/users';
$domain = 'https://sells.vsparts.cc';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $data = json_decode(file_get_contents('php://input'), true);
  $username = preg_replace('/[^a-zA-Z0-9_\-\.]/', '', $data['username']);
  $config = $data['config'] ?? '';

  if (!$username || !$config) {
    http_response_code(400);
    echo json_encode(['error' => 'نام کاربر یا کانفیگ خالی است.']);
    exit;
  }

  $userFolder = "$basePath/$username";
  if (!file_exists($userFolder)) {
    mkdir($userFolder, 0755, true);
  }

  // ذخیره فایل سابسکریپشن
  file_put_contents("$userFolder/sub.txt", $config);

  // لینک کوتاه نهایی
  $subLink = "$domain/users/$username/sub";
  $lines = explode("\n", trim($config));

  // ساخت HTML ساده با QR سابسکریپشن و لیست متنی کانکشن‌ها
  $html = "<!DOCTYPE html><html lang='fa'><head><meta charset='UTF-8'><title>اشتراک $username</title>
  <style>
    body { font-family: sans-serif; direction: rtl; background: #f0f0f0; padding: 20px; }
    .config { background: #fff; border: 1px solid #ccc; margin: 10px 0; padding: 10px; border-radius: 6px; direction: ltr; word-break: break-word; }
    canvas { margin-top: 10px; display: block; }
    a { word-break: break-all; font-size: 0.9em; color: blue; }
  </style>
  <script src='https://cdnjs.cloudflare.com/ajax/libs/qrious/4.0.2/qrious.min.js'></script>
  </head><body>
  <h2>👤 اشتراک کاربر: $username</h2>
  <p>🔗 لینک سابسکریپشن:</p>
  <p><a href='$subLink' target='_blank'>$subLink</a></p>
  <canvas id='qrSub'></canvas>
  <hr>
  <h3>لیست کانکشن‌ها:</h3>";

  foreach ($lines as $line) {
    $line = trim($line);
    if (!$line) continue;
    $encoded = htmlspecialchars($line, ENT_QUOTES, 'UTF-8');
    $html .= "<div class='config'>$encoded</div>";
  }

  $html .= "<script>
    new QRious({
      element: document.getElementById('qrSub'),
      value: '$subLink',
      size: 200
    });
  </script>
  </body></html>";

  file_put_contents("$userFolder/index.html", $html);

  echo json_encode([
    'link' => "$domain/users/$username/",
    'sub' => $subLink
  ]);
}
?>
